/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *
 *      DirectDraw gfx drivers header
 *
 *      By Stefan Schimanski.
 *
 *      See readme.txt for copyright information.
 */

#ifndef WDDRAW_H_INCLUDED
#define WDDRAW_H_INCLUDED

#define DIRECTDRAW_VERSION 0x0300

#include "allegro.h"
#include "allegro/aintern.h"
#include "allegro/aintwin.h"
#include <ddraw.h>

#ifndef ALLEGRO_WINDOWS
#error something is wrong with the makefile
#endif


/* general */
#define _enter_gfx_critical() EnterCriticalSection(&gfx_crit_sect);
#define _exit_gfx_critical() LeaveCriticalSection(&gfx_crit_sect);

AL_VAR(CRITICAL_SECTION, gfx_crit_sect);
AL_VAR(char *, pseudo_surf_mem);

typedef struct BMP_EXTRA_INFO {
   LPDIRECTDRAWSURFACE surf;
   struct BMP_EXTRA_INFO *next;
   struct BMP_EXTRA_INFO *prev;
   int flags;
   int lock_nesting;
} BMP_EXTRA_INFO;

#define BMP_EXTRA(bmp) ((BMP_EXTRA_INFO *)(bmp->extra))

#define BMP_FLAG_LOST      1

AL_VAR(LPDIRECTDRAW, directdraw);
AL_VAR(LPDIRECTDRAWSURFACE, dd_prim_surface);
AL_VAR(LPDIRECTDRAWPALETTE, dd_palette);
AL_VAR(LPDIRECTDRAWCLIPPER, dd_clipper);
AL_VAR(DDCAPS, dd_caps);
AL_VAR(LPDDPIXELFORMAT, dd_pixelformat);
AL_VAR(BITMAP *, dd_frontbuffer);


/* vtable routines */
AL_FUNC(void, gfx_directx_exit, (BITMAP *b));
AL_FUNC(void, gfx_directx_sync, (void));
AL_FUNC(void, gfx_directx_set_palette, (RGB *p, int from, int to, int vsync));
AL_FUNC(int, gfx_directx_poll_scroll, (void));
AL_FUNC(void, gfx_directx_created_sub_bitmap, (BITMAP *bmp, BITMAP *parent));
AL_FUNC(BITMAP *, gfx_directx_create_video_bitmap, (int width, int height));
AL_FUNC(void, gfx_directx_destroy_video_bitmap, (BITMAP *bitmap));
AL_FUNC(int, gfx_directx_show_video_bitmap, (BITMAP *bitmap));
AL_FUNC(int, gfx_directx_request_video_bitmap, (BITMAP *bitmap));
AL_FUNC(BITMAP *, gfx_directx_create_system_bitmap, (int width, int height));
AL_FUNC(void, gfx_directx_destroy_system_bitmap, (BITMAP *bitmap));
AL_FUNC(void, gfx_directx_destroy_surf, (LPDIRECTDRAWSURFACE surf));


/* driver initialisation and shutdown */
AL_FUNC(int, init_directx, (void));
AL_FUNC(int, set_video_mode, (int w, int h, int v_w, int v_h, int color_depth));
AL_FUNC(int, create_palette, (LPDIRECTDRAWSURFACE surf));
AL_FUNC(int, create_primary, (int w, int h, int color_depth));
AL_FUNC(int, create_clipper, (HWND hwnd));
AL_FUNC(int, setup_driver, (GFX_DRIVER * drv, int w, int h, int color_depth));
AL_FUNC(int, finalize_directx_init, (void));
AL_FUNC(int, gfx_directx_wnd_exit, (void));
AL_FUNC(void, gfx_directx_exit, (BITMAP *b));
AL_FUNC(int, enable_acceleration, (GFX_DRIVER * drv));
AL_FUNC(int, gfx_directx_update_color_format, (int color_depth));


/* bitmap locking */
AL_FUNC(void, gfx_directx_lock, (BITMAP *bmp));
AL_FUNC(void, gfx_directx_unlock, (BITMAP *bmp));
AL_FUNC(void, gfx_directx_release_lock, (BITMAP * bmp));
AL_FUNC(void, gfx_directx_write_bank, (void));
AL_FUNC(void, gfx_directx_unwrite_bank, (void));


/* bitmap creation */
AL_FUNC(LPDIRECTDRAWSURFACE, gfx_directx_create_surface, (int w, int h, int color_depth,
   int video, int primary, int overlay));
AL_FUNC(BITMAP *, make_directx_bitmap, (LPDIRECTDRAWSURFACE surf, int w, int h, int color_depth, int id));


/* video bitmap list */
AL_FUNC(void, register_directx_bitmap, (BITMAP *bmp));
AL_FUNC(void, unregister_directx_bitmap, (BITMAP *bmp));
AL_FUNC(void, unregister_all_directx_bitmaps, (void));
AL_FUNC(void, release_directx_bitmap, (struct BITMAP *bmp));

AL_VAR(BMP_EXTRA_INFO *, directx_bmp_list);


/* overlay */
AL_FUNC(void, hide_overlay, (void));
AL_FUNC(void, wddovl_switch_out, (void));
AL_FUNC(void, wddovl_switch_in, (void));

AL_VAR(LPDIRECTDRAWSURFACE, overlay_surface);
AL_VAR(BOOL, overlay_visible);
AL_VAR(int, wnd_x);
AL_VAR(int, wnd_y);
AL_VAR(int, wnd_width);
AL_VAR(int, wnd_height);
AL_VAR(int, wnd_windowed);
AL_VAR(int, wnd_sysmenu);


/* windowed mode */
AL_FUNC(void, handle_window_size_win, (void));
AL_FUNCPTR(void, update_window, (void));
AL_FUNC(void, wddwin_switch_out, (void));
AL_FUNC(void, wddwin_switch_in, (void));

AL_VAR(LPDIRECTDRAWSURFACE, dd_offscreen);


#endif

